unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ExtCtrls,
  UConsts,
  USG;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    Image1: TImage;
    sg: TStringGrid;
    procedure sgGetEditText(Sender: TObject; ACol, ARow: Integer; var Value: string);
    procedure sgGetEditMask(Sender: TObject; ACol, ARow: Integer; var Value: string);
    procedure sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
    procedure FormShow(Sender: TObject);
    procedure Image1Click(Sender: TObject);
  private

  public
	 procedure  Koniec();
	 procedure  Przypisz_lp();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
var
	ob : MSg;

begin
	sg.Align := alClient;

	ob := MSg.Create(sg);
   ob.Wypelnij();
   FreeAndNil(ob);
end;

procedure TMainForm.Image1Click(Sender: TObject);
begin
	Koniec();
end;

procedure TMainForm.Koniec();
begin
	if Application.MessageBox('Koniec pracy', 'Uwaga', MB_ICONINFORMATION or MB_YESNO) = mrYes then
	begin
		Close();
   end;
end;

procedure TMainForm.Przypisz_lp();
var
	ARow          : Integer;
   ACol          : Integer;
   ilosc_wierszy : Integer;
   lp            : Integer;

begin
	ARow          := 0;
   ACol          := 0;
   ilosc_wierszy := 0;
   lp            := 0;
	ARow          := 0;

   ilosc_wierszy := sg.RowCount;

	for ARow := 1 to ilosc_wierszy-1 do
	begin
   	sg.Cells[ACol, ARow] := IntToStr(ARow);
   end;

   sg.Invalidate();
end;

procedure TMainForm.sgDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect; State: TGridDrawState);
var
	inny_kolor : Boolean;
   txt        : String;
	x          : Integer;
	y          : Integer;

begin
	inny_kolor := false;
	txt        := '';
	x          := 0;
	y          := 0;

	if (ARow = 0) or (ACol = 0) then
   begin
   	exit;
   end;

   // co drugi rzd w innym kolorze
	inny_kolor := (ARow mod 2) = 0;

   if inny_kolor then
   begin
   	if not (gdFocused in State) then
      begin
      	txt := sg.Cells[ACol, ARow];

			// kolor niestandardowy
         sg.Canvas.Brush.Color := TColor($00D6EAEF);

         sg.Canvas.FillRect(Rect);

         x := Rect.Left + 2;
         y := (Rect.Top + Rect.Bottom - sg.Canvas.TextHeight(txt)) div 2;
         sg.Canvas.TextOut(x, y, txt);
      end;
   end;
end;

procedure TMainForm.sgGetEditMask(Sender: TObject; ACol, ARow: Integer; var Value: string);
begin
	(*
   Uwaga:
   wymagane aby bya aktywna opcja goEditing
   *)

	if (ACol = colKodp) then
   begin
 		Value := '99-999';
	end;

	if (ACol = colTel) then
   begin
		// Value ::= '000-00-00';
		Value := '(999) 000 00 00;1';
	   // Value :=  '!\(999\00 00 00;1';
   end;
end;

procedure TMainForm.sgGetEditText(Sender: TObject; ACol, ARow: Integer; var Value: string);
begin
	if (ACol = colMiasto) then
   begin
		Value := AnsiUpperCase(Value);
	end;
end;

end.

